//
//		Definition of the main game class
//
#ifndef THE_DECAL_MANAGER_H
#define THE_DECAL_MANAGER_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;


//...typedefs etc

#define maxNumDecals  256
#define maxNumWaves 9

#define hut1DecalX						480
#define hut1DecalY						576
#define hut2DecalX						369
#define hut2DecalY						805
#define hut3DecalX						448
#define hut3DecalY						1015
#define hospitalDecalX					665
#define hospitalDecalY					1246
#define hospitalFoundation2DecalX		775
#define hospitalFoundation2DecalY		1255

/*
typedef enum
{
	eSmallWave,
	eMedWave,
	eLargeWave,
	eTopShore,
	eBottomShore

} WaveGraphicEnum;
*/

/*
typedef struct{

	bool exists;
	ldwPoint		m_sPos;
	ldwPoint		m_sOffset;
	int waveVel;
	double angle;
	double angleStep;
	float waveOpacity;
	WaveGraphicEnum waveGraphic;

} OceanWavesType;
*/

typedef struct{

	bool exists;
	ldwPoint decalPosition;
	ldwImageGrid *decalImage;
	int column;

} DecalsType;
//END DEFINES

//BEGIN CLASS DECLARATION
class CDecal
{
	//class methods
	//setup
	public:		CDecal();
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	//OceanWavesType waves[maxNumWaves + 1];

	DecalsType decal[maxNumDecals];
	void InitDecals();
	void RefreshDecals();
	void AddDecal(ldwImageGrid *whatImage, int x, int y);
	void AddDecal(ldwImageGrid *whatImage, int x, int y, int column);
	void DrawDecals();
	void DrawArrow();
	//void DrawWaves();
	void DrawMiniDecals(int baseX,int baseY,float scale);

	void ShowArrow(ldwImage *arrow,int x,int y);
	void HideArrow();

	ldwImageGrid *scaffolding;

	ldwImageGrid *stoolfood;

	ldwImageGrid *carrystrip;

	ldwImageGrid *graves;
	ldwImageGrid *graveflowers;

	ldwImageGrid *firewood;
	ldwImageGrid *leafCover;

	ldwImageGrid *smallHuts;
	ldwImageGrid *hospital;

	ldwImageGrid *veggies;
	ldwImageGrid *dam;
	ldwImageGrid *wetFarm;
	ldwImageGrid *flood;
	ldwImageGrid *mosaicCovers1;
	ldwImageGrid *mosaicCovers2;
	ldwImageGrid *briars;

	ldwImageGrid *scarecrow;
//	ldwImageGrid *collectablesImages;
//	ldwImageGrid *smallShadow;

	ldwImageGrid *researchStates;

	//wave stuff
	ldwImageGrid *shore1;
	ldwImageGrid *shore2;
	ldwImageGrid *bigwave;
	ldwImageGrid *medwave;
	ldwImageGrid *smallwave;
	
	
	ldwImageGrid *vines1;
	ldwImageGrid *vines2;
	ldwImageGrid *vines3;
	ldwImageGrid *vines4;
	
	ldwImageGrid *smallflowers;
	ldwImageGrid *leaningSpears;
	ldwImageGrid *speartips;
	ldwImageGrid *coveredPot;
	ldwImageGrid *crate;
	ldwImageGrid *firestrip;

	ldwImageGrid *bathDamage;
	ldwImageGrid *bathFilled;

	ldwImageGrid *hospitalState;
	ldwImageGrid *amppuddle;
	
	ldwImageGrid *foodBin;
	ldwImageGrid *cape;

	ldwImageGrid *clothingHut;

private:
    	
	ldwGameWindow *gameWindow;
	theGameState  *gs;

	ldwImage *mArrow;
	ldwPoint  mArrowPos;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CDecal		Decal;

#endif